<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<?LassoScript
	// Include the library file which contains many of the tags 
	// that are utilized in these examples.
	library((string_replaceregexp: response_path, -find='(.*/).*?/', -replace='\\1') + 'library.lasso');
	// Include the library file which creates the required databases, tables and groups
	library('initialize.lasso');

	?>
	<style type="text/css">
		H2 { text-align: center; }
		TD {vertical-align:top}
		FORM { display: inline; }

		body
		{
			background-color: #DFFDDF;
		}
		.left_bar
		{
			background-color: #998DC9;
		}
		.group
		{
			background-color: #9D8ACC;
		}
		.item
		{
			background-color: #F9FFBF;
		}
	</style>
	<title>[Application_appInfo->title ' ' Application_appInfo->version]</title>
</head>
<body>
	<H2>Lasso Blog</H2>
	<?LassoScript
		/*
				Display the current user's authenticated name. If the user has 
			not logged in, provide a link to do so.
		*/
		'<div class="left_bar">\
		<b class="rboth1 rleftclr"></b><b class="rboth2 rleftclr"></b><b class="rboth3 rleftclr"></b><b class="rboth4 rleftclr"></b>';
		'<span class="group_title" id="login_info" xmlns="http://www.w3.org/1999/xhtml">\
		Hello, <i>'admin_currentusername'</i>';
		if (!$isLoggedIn);
			' <a href="' Application_appInfo->indexFile '?auth=1">(login)</a>';
		/if;
		'</span>';
		'<b class="rboth4 rleftclr"></b><b class="rboth3 rleftclr"></b><b class="rboth2 rleftclr"></b><b class="rboth1 rleftclr"></b>';
		'</div>';
	
		/*
				There are 3 pages to the blog. We decide which page we are on and 
			what should be shown on that page based on the presense or absence 
			of a parameter.
			
			Here are the main pages and their associated parameters:
			
			Blog List - <no parameters>
				The Blog list page lists all of the users who have blog entries
				in the system. The list consists of each author's name, the
				number of blog entries they have posted, and the date that the
				last entry was posted. Clicking on an author will lead to the
				author's blog entry list page. This page also displays the
				current user's name if they have been authenticated, or a link
				to authenticate if they haven't. If the user is authenticated,
				the page will show the new blog post form, which allows a user 
				to author and submit a new post.
			Blog Entry List - list=<author name>
				The blog entry list page shows all the blog entries for a
				particular user. Displayed are the entry's title, date and body 
				text. Below each entry, the number of comments posted for that 
				entry is shown. Blog entries are shown with the newest entry 
				first. Clicking on a blog entry's title or on the comment's 
				summary will lead to the blog entry detail page.
			Blog Detail - detail=<entry id>
				The blog entry detail page shows the same blog details as on the
				entry list page, but only that single entry is displayed and
				each comment is shown in detail. Also on this page is a form
				which allows the reader to post a new comment which will be
				added to the end of the comments list. This form consists of
				only a comment author name and the comment body text area. The
				comment author name can be any name and defaults to 'anonymous',
				i.e. it does not have to be an actual Lasso user name and no
				authentication is required.
				
			Each page has its own file which is included and handles the logic
			and display for that page. We will make a page variable that each
			include should set to true, if they were able to hande the request.
			If not set to true, the main blog list will be show				
		*/

		var('handled' = false);
		if (action_param('list'));
			include('entry_list.lasso');
		else (action_param('detail'));
			include('entry_detail.lasso');
		/if;
		// if it wasn't handled, do the blog author list
		!$handled?
			include('author_list.lasso');
	
		// include the footer that is shared by the examples
		include((string_replaceregexp: response_path, -find='(.*/).*?/', -replace='\\1') + 'examples_footer.lasso');
	?>
</body>
</html>
